package gov.va.med.mhv.journal.dto;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.journal.enums.MealTypeEnumeration;
import gov.va.med.mhv.journal.web.util.JournalDecorator;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@SuppressWarnings("unused")
public class FoodJournalDTO implements Serializable {

	private static final long serialVersionUID = 980109121169268152L;
	
	private Long foodJournalId;
	private Integer oplock;
	private BigDecimal glassesOfWater;
	private Date createdDate;
	private String comments;
	private Date journalDate;
	private Date modifiedDate;
	private Set<MealItemDTO> mealItems;
	private Long userId;
	private UserProfileDTO userProfile;
	
	private String dispJournalDate;
	private String summary;
	private int dayNoOfWeek;
	private String abbrWeekDay;
	private String weekDay;
	private String mealItemCount;
	
	// below lists are used in edit/delete page to display list of food/beverage items summary
	private List<String> breakFastItems;
	private List<String> lunchItems;
	private List<String> dinnerItems;
	private List<String> snackItems;
	
	//private MealItemDTO newMealItem;
	
	// below lists are used in edit/add food journal page
	private List<MealItemDTO> breakFastMealItems;
	private List<MealItemDTO> lunchMealItems;
	private List<MealItemDTO> dinnerMealItems;
	private List<MealItemDTO> snackMealItems;
	
	private Long mealItemId;
	private String mealType;
	private String servingSize;
	private BigDecimal quantity;
	private String prepMethod;
	private String item;
	
	public FoodJournalDTO() {		
	}
	
	public FoodJournalDTO(FoodJournalDTO foodJournal) {
		super();
		this.foodJournalId = foodJournal.getFoodJournalId();
		this.oplock = foodJournal.getOplock();
		this.glassesOfWater = foodJournal.getGlassesOfWater();
		this.createdDate = foodJournal.getCreatedDate();
		this.comments = foodJournal.getComments();
		this.journalDate = foodJournal.getJournalDate();
		this.modifiedDate = foodJournal.getModifiedDate();
		this.mealItems = new HashSet<MealItemDTO>();
		if (null != foodJournal.getMealItems()) {
			this.mealItems.addAll(foodJournal.getMealItems());
		}
		this.userId = foodJournal.getUserId();
		this.mealItemId = foodJournal.getMealItemId();
		this.mealType = foodJournal.getMealType();
		this.servingSize = foodJournal.getServingSize();
		this.quantity = foodJournal.getQuantity();
		this.prepMethod = foodJournal.getPrepMethod();
		this.item = foodJournal.getItem();
	}
	
	public Long getFoodJournalId() {
		return foodJournalId;
	}

	public void setFoodJournalId(Long foodJournalId) {
		this.foodJournalId = foodJournalId;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public BigDecimal getGlassesOfWater() {
		return glassesOfWater;
	}

	public void setGlassesOfWater(BigDecimal glassesOfWater) {
		this.glassesOfWater = glassesOfWater;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public Date getJournalDate() {
		return journalDate;
	}

	public void setJournalDate(Date journalDate) {
		this.journalDate = journalDate;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public Set<MealItemDTO> getMealItems() {
		if (mealItems == null) {
			mealItems = new HashSet<MealItemDTO>();
		}
		return mealItems;
	}
	
	public void setMealItems(Set<MealItemDTO> mealItems) {
		this.mealItems = mealItems;
	}

	public Long getUserId() {
		return userId;
	}
	
	public void setUserId(Long userId) {
		this.userId = userId;
	}
	
	public UserProfileDTO getUserProfile() {
		return userProfile;
	}

	public void setUserProfile(UserProfileDTO userProfile) {
		this.userProfile = userProfile;
	}
	
	public String getDispJournalDate() {
		return JournalDecorator.formatDate(getJournalDate());
	}
	
	public void setDispJournalDate(String dispJournalDate) {
		this.dispJournalDate = dispJournalDate;
	}
	
	public int getDayNoOfWeek() {
		return dayNoOfWeek;
	}
	
	public void setDayNoOfWeek(int dayNoOfWeek) {
		this.dayNoOfWeek = dayNoOfWeek;
	}
	
	public String getAbbrWeekDay() {
		return JournalDecorator.getAbbrDayOfWeek(getJournalDate());
	}
	
	public void setAbbrWeekDay(String abbrWeekDay) {
		this.abbrWeekDay = abbrWeekDay;
	}
	
	public String getWeekDay() {
		this.weekDay = JournalDecorator.getDayOfWeek(getJournalDate());
		return weekDay;
	}
	
	public void setWeekDay(String weekDay) {
		this.weekDay = weekDay;
	}
	
	public String getSummary() {
		this.summary = JournalDecorator.getFoodJournalSummary(this);
		return summary;
	}
	
	public void setSummary(String summary) {
		this.summary = summary;
	}
	
	public String getMealItemCount() {
		return JournalDecorator.getMealItemsCount(this);
	}
	
	public void setMealItemCount(String mealItemCount) {
		this.mealItemCount = mealItemCount;
	}

	public List<String> getBreakFastItems() {
		return JournalDecorator.getDecoratedItems(this, MealTypeEnumeration.BREAKFAST.getMealType());
	}

	public void setBreakFastItems(List<String> breakFastItems) {
		this.breakFastItems = breakFastItems;
	}

	public List<String> getLunchItems() {
		return JournalDecorator.getDecoratedItems(this, MealTypeEnumeration.LUNCH.getMealType());
	}

	public void setLunchItems(List<String> lunchItems) {
		this.lunchItems = lunchItems;
	}

	public List<String> getDinnerItems() {
		return JournalDecorator.getDecoratedItems(this, MealTypeEnumeration.DINNER.getMealType());
	}

	public void setDinnerItems(List<String> dinnerItems) {
		this.dinnerItems = dinnerItems;
	}

	public List<String> getSnackItems() {
		return JournalDecorator.getDecoratedItems(this, MealTypeEnumeration.SNACK.getMealType());
	}

	public void setSnackItems(List<String> snackItems) {
		this.snackItems = snackItems;
	}
	
	/*public MealItemDTO getNewMealItem() {
		return newMealItem;
	}
	
	public void setNewMealItem(MealItemDTO newMealItem) {
		this.newMealItem = newMealItem;
	}*/
	
	public List<MealItemDTO> getBreakFastMealItems() {
		return JournalDecorator.getMealItemsSubList(getMealItems(), MealTypeEnumeration.BREAKFAST.getMealType());
	}
	
	public void setBreakFastMealItems(List<MealItemDTO> breakFastMealItems) {
		this.breakFastMealItems = breakFastMealItems;
	}

	public List<MealItemDTO> getLunchMealItems() {
		return JournalDecorator.getMealItemsSubList(getMealItems(), MealTypeEnumeration.LUNCH.getMealType());
	}

	public void setLunchMealItems(List<MealItemDTO> lunchMealItems) {
		this.lunchMealItems = lunchMealItems;
	}

	public List<MealItemDTO> getDinnerMealItems() {
		return JournalDecorator.getMealItemsSubList(getMealItems(), MealTypeEnumeration.DINNER.getMealType());
	}

	public void setDinnerMealItems(List<MealItemDTO> dinnerMealItems) {
		this.dinnerMealItems = dinnerMealItems;
	}

	public List<MealItemDTO> getSnackMealItems() {
		return JournalDecorator.getMealItemsSubList(getMealItems(), MealTypeEnumeration.SNACK.getMealType());
	}

	public void setSnackMealItems(List<MealItemDTO> snackMealItems) {
		this.snackMealItems = snackMealItems;
	}

	public Long getMealItemId() {
		return mealItemId;
	}
	
	public void setMealItemId(Long mealItemId) {
		this.mealItemId = mealItemId;
	}
	
	public String getMealType() {
		return mealType;
	}

	public void setMealType(String mealType) {
		this.mealType = mealType;
	}

	public String getServingSize() {
		return servingSize;
	}

	public void setServingSize(String servingSize) {
		this.servingSize = servingSize;
	}

	public BigDecimal getQuantity() {
		return quantity;
	}

	public void setQuantity(BigDecimal quantity) {
		this.quantity = quantity;
	}

	public String getPrepMethod() {
		return prepMethod;
	}

	public void setPrepMethod(String prepMethod) {
		this.prepMethod = prepMethod;
	}
	
	public String getItem() {
		return item;
	}
	
	public void setItem(String item) {
		this.item = item;
	}
	
}
